<?php
session_start();

// ডেটাবেস সংযোগ
$conn = new mysqli('localhost', 'root', '', 'ledger_db');
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // ইউজারের ইনপুট সংগ্রহ
    $username = $_POST['username'];
    $password = $_POST['password'];
    $account_number = $_POST['account_number'];
    $address = $_POST['address'];

    // পাসওয়ার্ড হ্যাশ করা (সুরক্ষা জন্য)
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    // ডেটাবেসে ইনসার্ট করা
    $sql = "INSERT INTO users (username, password, account_number, address, role) 
            VALUES ('$username', '$hashed_password', '$account_number', '$address', 'customer')";

    if ($conn->query($sql) === TRUE) {
        $success_message = "New customer added successfully!";
    } else {
        $error_message = "Error: " . $conn->error;
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Customer</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

    <!-- Main container for the form -->
    <div class="container d-flex justify-content-center align-items-center vh-100">
        <div class="card shadow-lg" style="width: 30rem;">
            <div class="card-header bg-primary text-white text-center">
                <h3>Create New Customer Account</h3>
            </div>
            <div class="card-body">
                <form method="POST" action="add_customer.php">
                    <!-- Name -->
                    <div class="mb-3">
                        <label for="username" class="form-label">Name</label>
                        <input type="text" class="form-control" name="username" id="username" required>
                    </div>

                    <!-- Account Number -->
                    <div class="mb-3">
                        <label for="account_number" class="form-label">Account Number</label>
                        <input type="text" class="form-control" name="account_number" id="account_number" required>
                    </div>

                    <!-- Address -->
                    <div class="mb-3">
                        <label for="address" class="form-label">Address</label>
                        <textarea class="form-control" name="address" id="address" required></textarea>
                    </div>

                    <!-- Password -->
                    <div class="mb-3">
                        <label for="password" class="form-label">Password</label>
                        <input type="password" class="form-control" name="password" id="password" required>
                    </div>

                    <!-- Submit Button -->
                    <button type="submit" class="btn btn-primary w-100">Create Account</button>
                </form>
            </div>
            <div class="card-footer text-center">
                <a href="login.php" class="btn btn-link">Back to Login</a>
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS and dependencies -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Modal for Success Message -->
    <?php if (isset($success_message)) : ?>
    <div class="modal fade" id="successModal" tabindex="-1" aria-labelledby="successModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="successModalLabel">Success</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo $success_message; ?></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal" aria-label="Close">Close</button>
                </div>
            </div>
        </div>
    </div>
    <script>
        // Show the modal after the page loads
        var myModal = new bootstrap.Modal(document.getElementById('successModal'), {
            keyboard: false
        });
        myModal.show();
    </script>
    <?php endif; ?>

</body>
</html>
