<?php
session_start();

// যদি ইউজার লগইন না থাকে বা কাস্টমার না হয়
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'customer') {
    header("Location: login.php"); // লগইন পেজে রিডাইরেক্ট করা হচ্ছে
    exit;
}

// ডেটাবেস সংযোগ
$conn = new mysqli('localhost', 'root', '', 'ledger_db');
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// ইউজারের ট্রানজেকশন দেখানোর জন্য SQL কোয়েরি
$sql = "SELECT * FROM transactions WHERE user_id = ?";
echo "SQL Query: " . $sql . "<br>";  // ডিবাগিং - SQL কোয়েরি চেক করা
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $_SESSION['user_id']);  // ব্যবহারকারীর ID দিয়ে ট্রানজেকশন দেখাচ্ছে
$stmt->execute();
$result = $stmt->get_result();

// ডিবাগিং - ট্রানজেকশন রেজাল্ট চেক করা
echo "Number of transactions found: " . $result->num_rows . "<br>";  // ডিবাগিং - ফলাফল চেক

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Transactions</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f7fc;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 80%;
            margin: 50px auto;
        }

        table {
            width: 100%;
            margin-top: 30px;
            border-collapse: collapse;
        }

        table, th, td {
            border: 1px solid #ddd;
            padding: 10px;
        }

        th {
            background-color: #4a90e2;
            color: white;
        }

        tr:hover {
            background-color: #f1f1f1;
        }
    </style>
</head>
<body>

    <div class="container">
        <h1>Your Transactions</h1>

        <?php if ($result->num_rows > 0): ?>
            <table>
                <thead>
                    <tr>
                        <th>Transaction ID</th>
                        <th>Transaction Type</th>
                        <th>Amount</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $row['id']; ?></td>
                            <td><?php echo $row['transaction_type']; ?></td>
                            <td>$<?php echo number_format($row['amount'], 2); ?></td>
                            <td><?php echo $row['transaction_date']; ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>No transactions found.</p>
        <?php endif; ?>

    </div>

</body>
</html>
