<?php
session_start();

// ডেটাবেস সংযোগ
$conn = new mysqli('localhost', 'root', '', 'ledger_db');
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $account_number = $_POST['account_number'];
    $password = $_POST['password'];

    // ইউজারকে তার অ্যাকাউন্ট নম্বর দিয়ে খুঁজে বের করা
    $sql = "SELECT * FROM users WHERE account_number = '$account_number'";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        // ইউজার পাওয়া গেলে, পাসওয়ার্ড যাচাই করা
        $row = $result->fetch_assoc();

        // পাসওয়ার্ড যাচাই
        if (password_verify($password, $row['password'])) {
            $_SESSION['user_id'] = $row['id'];
            $_SESSION['username'] = $row['username'];
            $_SESSION['role'] = $row['role'];

            // রোল চেক করে আলাদা পেজে রিডাইরেক্ট করা
            if ($_SESSION['role'] == 'customer') {
                // কাস্টমারের জন্য ট্রানজেকশন পেজে রিডাইরেক্ট করা হবে
                header("Location: view_transactions.php");
            } elseif ($_SESSION['role'] == 'admin') {
                // এডমিনের জন্য ড্যাশবোর্ডে রিডাইরেক্ট করা হবে
                header("Location: dashboard.php");
            }
            exit;
        } else {
            echo "Invalid password!"; // পাসওয়ার্ড ভুল
        }
    } else {
        echo "No account found with that account number!"; // অ্যাকাউন্ট নম্বর ভুল
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f7fc;
            margin: 0;
            padding: 0;
        }

        /* Center the form container */
        .form-container {
            background-color: #fff;
            padding: 40px;
            border-radius: 10px;
            width: 400px; /* Fixed width for the form */
            margin: 100px auto;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            text-align: center;
        }

        h2 {
            color: #4a90e2;
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin: 10px 0 5px;
            font-weight: bold;
        }

        input {
            width: 100%;
            padding: 12px;
            margin: 8px 0 15px 0;
            border-radius: 5px;
            border: 1px solid #ccc;
        }

        input[type="submit"] {
            background-color: #4a90e2;
            color: white;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }

        input[type="submit"]:hover {
            background-color: #357ab7;
        }

        .back-link {
            display: inline-block;
            margin-top: 20px;
            text-decoration: none;
            background-color: #4a90e2;
            color: white;
            padding: 10px 20px;
            border-radius: 25px;
            text-align: center;
        }

        .back-link:hover {
            background-color: #357ab7;
        }

        /* Footer styles */
        footer {
            background-color: #4a90e2;
            color: white;
            text-align: center;
            padding: 10px;
            position: fixed;
            bottom: 0;
            width: 100%;
            font-size: 14px;
        }
    </style>
</head>
<body>

    <div class="form-container">
	<h2>City Bank Nangalkot CRM Ledger </h2>
        <h2>Login</h2>
        <form method="POST" action="login.php">
            <!-- Account Number -->
            <label for="account_number">Account Number:</label>
            <input type="text" name="account_number" id="account_number" required>

            <!-- Password -->
            <label for="password">Password:</label>
            <input type="password" name="password" id="password" required>

            <!-- Submit Button -->
            <input type="submit" value="Login">
        </form>

        <a href="add_customer.php" class="back-link">Create an Account</a>
    </div>

    <!-- Footer -->
    <footer>
        <p>Developed By Nesar A Nishan</p>
    </footer>

</body>
</html>
