<?php
session_start();

// যদি ইউজার লগইন না থাকে বা কাস্টমার না হয়
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'customer') {
    header("Location: login.php"); // লগইন পেজে রিডাইরেক্ট করা হচ্ছে
    exit;
}

// ডেটাবেস সংযোগ
$conn = new mysqli('localhost', 'root', '', 'ledger_db');
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// ইউজারের তথ্য দেখানোর জন্য SQL কোয়েরি
$user_id = $_SESSION['user_id'];  // সেশন থেকে ইউজার আইডি নিচ্ছি

// কাস্টমারের তথ্য ফেচ করা
$user_sql = "SELECT * FROM users WHERE id = ?";
$user_stmt = $conn->prepare($user_sql);
$user_stmt->bind_param("i", $user_id);
$user_stmt->execute();
$user_result = $user_stmt->get_result();
$user_info = $user_result->fetch_assoc();

// কাস্টমারের account_number
$account_number = $user_info['account_number'];  // অ্যাকাউন্ট নাম্বার 

// SQL কোয়েরি
$sql = "SELECT t.id, t.transaction_type, t.amount, t.date, t.cheque, t.description, t.balance
        FROM transactions t
        WHERE t.account_number = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $account_number); 
$stmt->execute();
$result = $stmt->get_result();

// সর্বমোট Deposit এবং Withdraw এর হিসাব
$total_deposit = 0;
$total_withdraw = 0;
$balance = 0;
while ($row = $result->fetch_assoc()) {
    // Balance calculation based on transaction type
    if ($row['transaction_type'] == 'deposit') {
        $total_deposit += $row['amount'];
        $balance += $row['amount'];
    } elseif ($row['transaction_type'] == 'withdraw') {
        $total_withdraw += $row['amount'];
        $balance -= $row['amount'];
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Transactions</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f7fc;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 80%;
            margin: 50px auto;
            display: flex;
            gap: 30px;
        }

        /* Sidebar */
        .sidebar {
            width: 25%;
            background-color: #f9f9f9;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .sidebar h3 {
            color: #4a90e2;
        }

        .sidebar p {
            font-size: 14px;
            margin-bottom: 10px;
        }

        /* Transactions Table */
        .transactions-table {
            width: 75%;
            background-color: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        table {
            width: 100%;
            margin-top: 30px;
            border-collapse: collapse;
        }

        table, th, td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: center;
        }

        th {
            background-color: #4a90e2;
            color: white;
        }

        tr:hover {
            background-color: #f1f1f1;
        }

        .header {
            display: flex;
            justify-content: space-between;
            background-color: #4a90e2;
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            margin-bottom: 20px;
        }

        .logout-btn {
            background-color: #fff;
            color: #4a90e2;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
        }

        .logout-btn:hover {
            background-color: #357ab7;
            color: white;
        }

        /* Tab Styles */
        .tabs {
            display: flex;
            justify-content: space-around;
            margin-bottom: 20px;
        }

        .tabs button {
            background-color: #4a90e2;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }

        .tabs button:hover {
            background-color: #357ab7;
        }

        .tabs button.active {
            background-color: #357ab7;
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }

        /* Summary Styling */
        .summary {
            background-color: #f4f7fc;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .summary h3 {
            margin-bottom: 10px;
        }

        .summary p {
            margin: 5px 0;
        }
    </style>
</head>
<body>

    <div class="container">
        <!-- Sidebar Section with user details -->
        <div class="sidebar">
            <h3>Customer Information</h3>
            <p><strong>Name:</strong> <?php echo $user_info['username']; ?></p>
            <p><strong>Account Number:</strong> <?php echo $user_info['account_number']; ?></p>
            <p><strong>Address:</strong> <?php echo $user_info['address']; ?></p>
        </div>

        <!-- Transactions Table Section -->
        <div class="transactions-table">
            <div class="header">
                <h1>Your Transactions</h1>
                <form method="POST" style="display:inline;">
                    <button type="submit" name="logout" class="logout-btn">Logout</button>
                </form>
            </div>

            <!-- Tabs Section -->
            <div class="tabs">
                <button id="summary-tab" class="active" onclick="showTab('summary')">Summary</button>
                <button id="transactions-tab" onclick="showTab('transactions')">Transactions</button>
            </div>

            <!-- Summary Section -->
            <div id="summary" class="tab-content active">
                <div class="summary">
                    <h3>Summary</h3>
                    <p><strong>Total Deposit:</strong> <?php echo number_format($total_deposit, 2); ?></p>
                    <p><strong>Total Withdraw:</strong> <?php echo number_format($total_withdraw, 2); ?></p>
                    <p><strong>Final Balance:</strong> <?php echo number_format($balance, 2); ?></p>
                </div>
            </div>

            <!-- Transactions Section -->
            <div id="transactions" class="tab-content">
                <table>
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Cheque</th>
                            <th>Description</th>
                            <th>Withdraw</th>
                            <th>Deposit</th>
                            <th>Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $balance = 0;
                        while ($row = $result->fetch_assoc()):
                            // Balance calculation based on transaction type
                            if ($row['transaction_type'] == 'deposit') {
                                $balance += $row['amount'];
                            } elseif ($row['transaction_type'] == 'withdraw') {
                                $balance -= $row['amount'];
                            }
                        ?>
                            <tr>
                                <td><?php echo $row['date']; ?></td>
                                <td><?php echo $row['cheque']; ?></td>
                                <td><?php echo $row['description']; ?></td>
                                <td><?php echo ($row['transaction_type'] == 'withdraw') ? number_format($row['amount'], 2) : '0.00'; ?></td>
                                <td><?php echo ($row['transaction_type'] == 'deposit') ? number_format($row['amount'], 2) : '0.00'; ?></td>
                                <td><?php echo number_format($balance, 2); ?></td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        function showTab(tabName) {
            var tabs = document.querySelectorAll('.tab-content');
            var buttons = document.querySelectorAll('.tabs button');
            
            tabs.forEach(function(tab) {
                tab.classList.remove('active');
            });
            
            buttons.forEach(function(button) {
                button.classList.remove('active');
            });

            document.getElementById(tabName).classList.add('active');
            document.getElementById(tabName + '-tab').classList.add('active');
        }
    </script>

</body>
</html>

<?php
// লগ আউট করার কোড
if (isset($_POST['logout'])) {
    session_unset();
    session_destroy();
    header("Location: login.php");
    exit;
}
?>
