<?php
session_start();

// ডেটাবেস সংযোগ
include('includes/db.php');
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // ইনপুট ডাটা সংগ্রহ
    $name = $_POST['name'];
    $account_number = $_POST['account_number'];
    $datetime = $_POST['datetime']; // তারিখ এবং সময়
    $cheque = $_POST['cheque'];
    $description = $_POST['description'];
    $amount = $_POST['amount'];
    $transaction_type = $_POST['transaction_type']; // Withdraw or Deposit
    
    // ব্যালেন্স হিসাব করা (এটা কেবল উইথড্র এবং ডিপোজিট এর উপর ভিত্তি করে হবে)
    if ($transaction_type == "withdraw") {
        $balance = -$amount; // উইথড্রালে ব্যালেন্স নেগেটিভ
    } else {
        $balance = $amount; // ডিপোজিটে ব্যালেন্স পজিটিভ
    }
    
    // লেনদেন ইনসার্ট করা
    $sql = "INSERT INTO transactions (user_id, name, account_number, date, cheque, description, amount, transaction_type, balance) 
            VALUES ('$_SESSION[user_id]', '$name', '$account_number', '$datetime', '$cheque', '$description', '$amount', '$transaction_type', '$balance')";
    
    if ($conn->query($sql) === TRUE) {
        echo "<script>alert('New transaction added successfully!');</script>";
    } else {
        echo "Error: " . $conn->error;
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Transaction</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f7fc;
            margin: 0;
            padding: 0;
        }

        .form-container {
            background-color: #fff;
            padding: 20px;
            border-radius: 10px;
            max-width: 400px;
            margin: 50px auto;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        h2 {
            color: #4a90e2;
            text-align: center;
            margin-bottom: 20px;
        }

        .back-link {
            display: inline-block;
            margin-top: 20px;
            text-decoration: none;
            background-color: #4a90e2;
            color: white;
            padding: 10px 20px;
            border-radius: 25px;
            text-align: center;
        }

        .back-link:hover {
            background-color: #357ab7;
        }
    </style>
</head>
<body>

    <div class="form-container">
        <h2>Add Transaction</h2>
        <form method="POST" action="add_transaction.php">
            <!-- Name -->
            <div class="mb-3">
                <label for="name" class="form-label">Name:</label>
                <input type="text" class="form-control" name="name" id="name" required>
            </div>

            <!-- Account Number -->
            <div class="mb-3">
                <label for="account_number" class="form-label">Account Number:</label>
                <input type="text" class="form-control" name="account_number" id="account_number" required>
            </div>

            <!-- Date and Time -->
            <div class="mb-3">
                <label for="datetime" class="form-label">Date and Time:</label>
                <input type="datetime-local" class="form-control" name="datetime" id="datetime" required>
            </div>

            <!-- Cheque -->
            <div class="mb-3">
                <label for="cheque" class="form-label">Cheque Number:</label>
                <input type="text" class="form-control" name="cheque" id="cheque" required>
            </div>

            <!-- Description -->
            <div class="mb-3">
                <label for="description" class="form-label">Description:</label>
                <textarea class="form-control" name="description" id="description" required></textarea>
            </div>

            <!-- Transaction Type (Withdraw or Deposit) -->
            <div class="mb-3">
                <label for="transaction_type" class="form-label">Transaction Type:</label>
                <select class="form-select" name="transaction_type" id="transaction_type" required>
                    <option value="deposit">Deposit</option>
                    <option value="withdraw">Withdraw</option>
                </select>
            </div>

            <!-- Amount -->
            <div class="mb-3">
                <label for="amount" class="form-label">Amount:</label>
                <input type="number" class="form-control" name="amount" id="amount" min="0" step="any" required>
            </div>

            <!-- Submit Button -->
            <button type="submit" class="btn btn-primary w-100">Add Transaction</button>
        </form>

        <a href="dashboard.php" class="back-link">Back to Dashboard</a>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
