<?php
session_start();

// যদি ইউজার লগইন না থাকে বা এডমিন না হয়
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit;
}

// ডেটাবেস সংযোগ
include('includes/db.php');
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// সব ট্রানজেকশন সংগ্রহ করা (তারিখ এবং সময় সহ)
$sql_transactions = "SELECT t.account_number, u.username, 
                            DATE_FORMAT(t.date, '%Y-%m-%d %r') AS date_time, 
                            t.amount, t.transaction_type, t.description, t.id
                    FROM transactions t 
                    JOIN users u ON t.account_number = u.account_number 
                    ORDER BY t.date DESC";
$result_transactions = $conn->query($sql_transactions);

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>All Transactions</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f8fb;
            color: #333;
        }

        .container {
            margin-top: 50px;
        }

        h2 {
            color: #0044cc;
            font-weight: bold;
            margin-bottom: 30px;
        }

        .table-wrapper {
            background-color: #ffffff;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            padding: 20px;
        }

        .table {
            margin-top: 20px;
            border-collapse: collapse;
            width: 100%;
        }

        th, td {
            text-align: center;
            padding: 15px;
            border: 1px solid #ddd;
        }

        th {
            background-color: #007bff;
            color: black;
            font-size: 14px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        .back-link {
            display: inline-block;
            margin-top: 20px;
            text-decoration: none;
            background-color: #007bff;
            color: white;
            padding: 12px 25px;
            border-radius: 25px;
            text-align: center;
            font-size: 16px;
        }

        .back-link:hover {
            background-color: #0056b3;
        }

        .print-btn {
            background-color: #28a745;
            color: white;
            padding: 12px 20px;
            border-radius: 25px;
            text-decoration: none;
            font-size: 16px;
            margin-bottom: 20px;
        }

        .print-btn:hover {
            background-color: #218838;
        }

        .actions-btn {
            display: flex;
            justify-content: space-around;
        }

        .actions-btn a {
            text-decoration: none;
            color: white;
            padding: 8px 15px;
            border-radius: 5px;
            margin: 0 5px;
        }

        .actions-btn .btn-edit {
            background-color: #ffbb33;
        }

        .actions-btn .btn-edit:hover {
            background-color: #e6a700;
        }

        .actions-btn .btn-delete {
            background-color: #dc3545;
        }

        .actions-btn .btn-delete:hover {
            background-color: #c82333;
        }

        /* Print styles */
        @media print {
            body {
                background-color: white;
            }
            .container {
                margin-top: 0;
            }
            .back-link, .print-btn {
                display: none;
            }
            table {
                width: 100%;
                border-collapse: collapse;
            }
            th, td {
                padding: 10px;
                border: 1px solid #ddd;
                text-align: center;
            }
            th {
                background-color: #007bff;
                color: white;
            }
        }
    </style>
</head>
<body>

    <div class="container">
        <h2 class="text-center">All Transactions</h2>

        <!-- Print Button -->
        <a href="javascript:window.print()" class="print-btn">Print</a>

        <div class="table-wrapper">
            <table class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>Date and Time</th>
                        <th>Name</th>
                        <th>Account Number</th>
                        <th>Transaction Amount (BDT)</th>
                        <th>Transaction Type</th>
                        <th>Description</th>
                        <th>Actions</th> <!-- Added Actions Column -->
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result_transactions->num_rows > 0) {
                        while ($row = $result_transactions->fetch_assoc()) { ?>
                            <tr>
                                <td><?php echo $row['date_time']; ?></td>
                                <td><?php echo $row['username']; ?></td>
                                <td><?php echo $row['account_number']; ?></td>
                                <td>BDT <?php echo number_format($row['amount']); ?></td>
                                <td><?php echo $row['transaction_type']; ?></td>
                                <td><?php echo $row['description']; ?></td>
                                <td class="actions-btn">
                                    <!-- Edit and Delete buttons -->
                                    <a href="edit_transaction.php?id=<?php echo $row['id']; ?>" class="btn btn-warning btn-sm btn-edit">Edit</a>
                                    <a href="delete_transaction.php?id=<?php echo $row['id']; ?>" class="btn btn-danger btn-sm btn-delete" onclick="return confirm('Are you sure you want to delete?')">Delete</a>
                                </td>
                            </tr>
                    <?php }
                    } else {
                        echo "<tr><td colspan='7' class='text-center'>No transactions found</td></tr>";
                    } ?>
                </tbody>
            </table>
        </div>

        <a href="dashboard.php" class="back-link">Back to Dashboard</a>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
