<?php
session_start();

// ডেটাবেস সংযোগ
include('includes/db.php');
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// যদি ইউজারের ID পাওয়া যায়
if (isset($_GET['id'])) {
    $user_id = $_GET['id'];
    
    // ইউজারের তথ্য ফেচ করা
    $sql = "SELECT * FROM users WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $user_data = $result->fetch_assoc();
    } else {
        echo "No user found!";
        exit;
    }
}

// তথ্য আপডেট করার পদ্ধতি
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['username'];
    $account_number = $_POST['account_number'];
    $address = $_POST['address'];
    
    // ইউজারের তথ্য আপডেট করা
    $sql_update = "UPDATE users SET username = ?, account_number = ?, address = ? WHERE id = ?";
    $stmt_update = $conn->prepare($sql_update);
    $stmt_update->bind_param("sssi", $username, $account_number, $address, $user_id);
    
    if ($stmt_update->execute()) {
        echo "<script>alert('Customer updated successfully!'); window.location.href = 'view_customers.php';</script>";
    } else {
        echo "Error: " . $conn->error;
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Customer</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #ff7f50, #1e90ff); /* Beautiful gradient colors */
            min-height: 100vh;
        }

        .container {
            margin-top: 80px;
        }

        .card {
            background-color: rgba(255, 255, 255, 0.9);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.1);
        }

        .form-control, .btn {
            transition: all 0.3s ease;
        }

        .form-control:focus, .btn:focus {
            box-shadow: 0 0 0 0.25rem rgba(0, 123, 255, 0.5);
        }

        .btn-primary {
            background-color: #28a745;
            border-color: #28a745;
        }

        .btn-primary:hover {
            background-color: #218838;
            border-color: #1e7e34;
        }

        .back-btn {
            position: fixed;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            padding: 10px 30px;
            background-color: #007bff;
            color: white;
            font-size: 16px;
            border-radius: 30px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.2);
            transition: background-color 0.3s ease;
        }

        .back-btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>

    <div class="container">
        <div class="card">
            <div class="card-header bg-primary text-white text-center">
                <h3>Edit Customer Information</h3>
            </div>

            <div class="card-body">
                <!-- Form for editing customer -->
                <form method="POST" action="edit_customer.php?id=<?php echo $user_data['id']; ?>">
                    <div class="mb-3">
                        <label for="username" class="form-label">Name</label>
                        <input type="text" class="form-control" name="username" id="username" value="<?php echo $user_data['username']; ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="account_number" class="form-label">Account Number</label>
                        <input type="text" class="form-control" name="account_number" id="account_number" value="<?php echo $user_data['account_number']; ?>" required>
                    </div>

                    <div class="mb-3">
                        <label for="address" class="form-label">Address</label>
                        <textarea class="form-control" name="address" id="address" required><?php echo $user_data['address']; ?></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary w-100">Update Customer</button>
                </form>
            </div>
        </div>
    </div>

    <!-- Back to Customer List Button -->
    <a href="view_customers.php" class="back-btn">Back to Customer List</a>

    <!-- Bootstrap 5 JS and dependencies -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
