<?php
session_start();

// যদি ইউজার লগইন না থাকে বা এডমিন না হয়
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit;
}

// ডেটাবেস সংযোগ
include('includes/db.php');
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// ট্রানজেকশন তথ্য সম্পাদনার জন্য
if (isset($_GET['id'])) {
    $transaction_id = $_GET['id'];

    // ট্রানজেকশন নির্বাচন করা
    $sql = "SELECT * FROM transactions WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $transaction_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $transaction = $result->fetch_assoc();
    } else {
        echo "Transaction not found.";
        exit;
    }
}

// ট্রানজেকশন আপডেট করা
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = $_POST['name'];
    $account_number = $_POST['account_number'];
    $datetime = $_POST['datetime'];  // তারিখ এবং সময়
    $cheque = $_POST['cheque'];
    $description = $_POST['description'];
    $amount = $_POST['amount'];
    $transaction_type = $_POST['transaction_type']; // Withdraw or Deposit
    
    // ব্যালেন্স হিসাব করা (এটা কেবল উইথড্র এবং ডিপোজিট এর উপর ভিত্তি করে হবে)
    if ($transaction_type == "withdraw") {
        $balance = -$amount; // উইথড্রালে ব্যালেন্স নেগেটিভ
    } else {
        $balance = $amount; // ডিপোজিটে ব্যালেন্স পজিটিভ
    }

    // আপডেট লেনদেন
    $sql_update = "UPDATE transactions SET name = ?, account_number = ?, date = ?, cheque = ?, description = ?, amount = ?, transaction_type = ?, balance = ? WHERE id = ?";
    $stmt_update = $conn->prepare($sql_update);
    $stmt_update->bind_param("ssssssssi", $name, $account_number, $datetime, $cheque, $description, $amount, $transaction_type, $balance, $transaction_id);

    if ($stmt_update->execute()) {
        echo "<script>alert('Transaction updated successfully!'); window.location.href = 'allview_transactions.php';</script>";
    } else {
        echo "Error: " . $conn->error;
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Transaction</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f8fb;
            color: black;
        }

        .container {
            margin-top: 50px;
            max-width: 600px;
        }

        h2 {
            color: #0044cc;
            font-weight: bold;
            margin-bottom: 30px;
            text-align: center;
        }

        .form-container {
            background-color: #ffffff;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .form-label {
            font-size: 14px;
            font-weight: bold;
        }

        .form-control {
            border-radius: 5px;
            padding: 8px;
            font-size: 14px;
        }

        .form-control:focus {
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
        }

        .submit-btn {
            background-color: #007bff;
            color: white;
            padding: 10px 20px;
            border-radius: 25px;
            font-size: 14px;
            width: 100%;
            margin-top: 20px;
        }

        .submit-btn:hover {
            background-color: #0056b3;
        }

        .back-link {
            display: inline-block;
            margin-top: 20px;
            text-decoration: none;
            background-color: #28a745;
            color: white;
            padding: 10px 20px;
            border-radius: 25px;
            text-align: center;
        }

        .back-link:hover {
            background-color: #218838;
        }

        .form-row {
            margin-bottom: 15px;
        }
    </style>
</head>
<body>

    <div class="container">
        <h2>Edit Transaction</h2>

        <div class="form-container">
            <form method="POST" action="edit_transaction.php?id=<?php echo $transaction['id']; ?>">
                <!-- Name -->
                <div class="form-row">
                    <label for="name" class="form-label">Name:</label>
                    <input type="text" class="form-control" name="name" id="name" value="<?php echo $transaction['name']; ?>" required>
                </div>

                <!-- Account Number -->
                <div class="form-row">
                    <label for="account_number" class="form-label">Account Number:</label>
                    <input type="text" class="form-control" name="account_number" id="account_number" value="<?php echo $transaction['account_number']; ?>" required>
                </div>

                <!-- Date and Time -->
                <div class="form-row">
                    <label for="datetime" class="form-label">Date and Time:</label>
                    <input type="datetime-local" class="form-control" name="datetime" id="datetime" value="<?php echo date('Y-m-d\TH:i', strtotime($transaction['date'])); ?>" required>
                </div>

                <!-- Cheque -->
                <div class="form-row">
                    <label for="cheque" class="form-label">Cheque Number:</label>
                    <input type="text" class="form-control" name="cheque" id="cheque" value="<?php echo $transaction['cheque']; ?>" required>
                </div>

                <!-- Description -->
                <div class="form-row">
                    <label for="description" class="form-label">Description:</label>
                    <textarea class="form-control" name="description" id="description" required><?php echo $transaction['description']; ?></textarea>
                </div>

                <!-- Transaction Type -->
                <div class="form-row">
                    <label for="transaction_type" class="form-label">Transaction Type:</label>
                    <select class="form-select" name="transaction_type" id="transaction_type" required>
                        <option value="deposit" <?php echo $transaction['transaction_type'] == 'deposit' ? 'selected' : ''; ?>>Deposit</option>
                        <option value="withdraw" <?php echo $transaction['transaction_type'] == 'withdraw' ? 'selected' : ''; ?>>Withdraw</option>
                    </select>
                </div>

                <!-- Amount -->
                <div class="form-row">
                    <label for="amount" class="form-label">Amount:</label>
                    <input type="number" class="form-control" name="amount" id="amount" value="<?php echo $transaction['amount']; ?>" min="0" step="any" required>
                </div>

                <!-- Submit Button -->
                <button type="submit" class="submit-btn">Update Transaction</button>
            </form>

            <a href="allview_transactions.php" class="back-link">Back to Transactions</a>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
